// External oscillator frequency
#define SYSCLK          32000000
#include "p24fj128ga008.h"
//#include "lcd.h"

// Setup configuration bits
_CONFIG1( JTAGEN_OFF & GCP_OFF & GWRP_OFF & COE_OFF & FWDTEN_OFF & ICS_PGx2) 
_CONFIG2( FCKSM_CSDCMD & OSCIOFNC_ON & POSCMOD_HS & FNOSC_PRIPLL )

#define   DELAY 16000
#define   BRATE   34        // 115200 Bd (BREGH=1)
#define   U_ENABLE 0x8008   // enable UART, BREGH=1, 1 stop, no parity
#define   U_TX 0x0400       // enable transmission, clear all fl ags

void initU2( void)
{

  // BREG2 = (Fosc / 8 / 115,200) -1 = 33.7 where Fosc = 32MHz.
	U2BRG = BRATE; // initialize the baud rate generator
	U2MODE = U_ENABLE; // initialize the UART module
	U2STA = U_TX; // enable the Transmitter

} // initU2

int putU2( int c)
{
	while ( U2STAbits.UTXBF); // wait while Tx buffer full
	U2TXREG = c;
return c;
} // putU2

char getU2( void)
{
	while ( !U2STAbits.URXDA); // wait for a new character to arrive
	return  U2RXREG;           // read the character from the receive buffer
}// getU2

//--------------------------------------------------------------------------------
int main ()
{   
   int i;
   char c;
   unsigned char text[]="HELLO";

	//Code goes here                                   								
    initU2();    // init the UART2 serial port

  for (i=0;i<sizeof(text);i++)   // Print HELLO
  {
      putU2(text[i]);
  }

    putU2( '>');        //  prompt

	while (1)
	{
		c = getU2();    // wait for a character
		putU2( c);      // echo the character

	} // End While
}  // End main
//--------------------------------------------------------------------------------